<?php

namespace App\Repository;

use App\Entity\Triagem;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Triagem>
 *
 * @method Triagem|null find($id, $lockMode = null, $lockVersion = null)
 * @method Triagem|null findOneBy(array $criteria, array $orderBy = null)
 * @method Triagem[]    findAll()
 * @method Triagem[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class TriagemRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Triagem::class);
    }

    public function save(Triagem $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(Triagem $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }
    /**
     * @return Triagem[] Returns an array of Triagem objects
     */
    public function findTriagens(): array
    {
        return $this->createQueryBuilder('t')
            ->where('t.isAtivo = true')
            ->join('t.paciente','p')
            ->orderBy('t.id', 'ASC')
            ->getQuery()
            ->getResult()
            ;
    }


//    /**
//     * @return Triagem[] Returns an array of Triagem objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('t')
//            ->andWhere('t.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('t.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?Triagem
//    {
//        return $this->createQueryBuilder('t')
//            ->andWhere('t.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
