<?php

namespace App\Repository;

use App\Entity\TipoDeSeguradora;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<TipoDeSeguradora>
 *
 * @method TipoDeSeguradora|null find($id, $lockMode = null, $lockVersion = null)
 * @method TipoDeSeguradora|null findOneBy(array $criteria, array $orderBy = null)
 * @method TipoDeSeguradora[]    findAll()
 * @method TipoDeSeguradora[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class TipoDeSeguradoraRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, TipoDeSeguradora::class);
    }

    public function save(TipoDeSeguradora $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(TipoDeSeguradora $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

//    /**
//     * @return TipoDeSeguradora[] Returns an array of TipoDeSeguradora objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('t')
//            ->andWhere('t.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('t.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?TipoDeSeguradora
//    {
//        return $this->createQueryBuilder('t')
//            ->andWhere('t.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
