<?php

namespace App\Repository;

use App\Entity\MarcacaoConsulta;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use function Doctrine\Common\Collections\where;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<MarcacaoConsulta>
 *
 * @method MarcacaoConsulta|null find($id, $lockMode = null, $lockVersion = null)
 * @method MarcacaoConsulta|null findOneBy(array $criteria, array $orderBy = null)
 * @method MarcacaoConsulta[]    findAll()
 * @method MarcacaoConsulta[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class MarcacaoConsultaRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, MarcacaoConsulta::class);
    }

    public function save(MarcacaoConsulta $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(MarcacaoConsulta $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    /**
     * @return MarcacaoConsulta[] Returns an array of Municipio objects
     */
    public function findMarcacaoConsultas(): array
    {
        return $this->createQueryBuilder('m')
            ->orderBy('m.id', 'ASC')
            ->getQuery()
            ->getResult()
            ;
    }

    /**
     * @return MarcacaoConsulta[] Returns an array of Municipio objects
     */
    public function findMarcacaoConsultasByMedico($medico): array
    {
        return $this->createQueryBuilder('m')
            ->andWhere('ag.medico = :val')
            ->join('m.calendarioMedico','ag')
            ->setParameter('val',$medico)
            ->orderBy('m.id', 'ASC')
            ->getQuery()
            ->getResult()
            ;
    }

//    /**
//     * @return MarcacaoConsulta[] Returns an array of MarcacaoConsulta objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('m')
//            ->andWhere('m.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('m.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?MarcacaoConsulta
//    {
//        return $this->createQueryBuilder('m')
//            ->andWhere('m.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
