<?php

namespace App\Repository;

use App\Entity\Bairro;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Bairro>
 *
 * @method Bairro|null find($id, $lockMode = null, $lockVersion = null)
 * @method Bairro|null findOneBy(array $criteria, array $orderBy = null)
 * @method Bairro[]    findAll()
 * @method Bairro[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class BairroRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Bairro::class);
    }

    public function save(Bairro $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(Bairro $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }



    /**
     * @return Municipio[] Returns an array of Municipio objects
     */
    public function findBairros(): array
    {
        return $this->createQueryBuilder('b')
            ->join('b.comuna','c')
            ->join('c.municipio','m')
            ->join('m.provincia','p')
            ->orderBy('b.id', 'ASC')
            ->getQuery()
            ->getResult()
            ;
    }

//    /**
//     * @return Bairro[] Returns an array of Bairro objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('b')
//            ->andWhere('b.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('b.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?Bairro
//    {
//        return $this->createQueryBuilder('b')
//            ->andWhere('b.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
