<?php

namespace App\Form;

use App\Entity\Bairro;
use App\Entity\Empresa;
use App\Repository\BairroRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Vich\UploaderBundle\Form\Type\VichImageType;

class EmpresaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nome')
            ->add('nif')
            ->add('telefone')
            ->add('bairro',EntityType::class,[
                'class'=> Bairro::class,
                'choice_label' => 'nome',
                'label' => 'Bairro',
                'query_builder' => function(BairroRepository $bairroRepository){
                    return $bairroRepository->createQueryBuilder('p')
                        ->orderBy('p.nome','ASC');
                }
            ])
            ->add('imageFile',VichImageType::class)
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Empresa::class,
        ]);
    }
}
