<?php

namespace App\Form;

use App\Entity\Bairro;
use App\Entity\Comuna;
use App\Repository\ComunaRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class BairroType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nome')
            ->add('comuna',EntityType::class,[
                'class'=> Comuna::class,
                'choice_label' => 'nome',
                'label' => 'Comuna',
                'query_builder' => function(ComunaRepository $comunaRepository){
                    return $comunaRepository->createQueryBuilder('p')
                        ->orderBy('p.nome','ASC');
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Bairro::class,
        ]);
    }
}
