<?php

namespace App\Form;

use App\Entity\AssegurarPaciente;
use App\Entity\Paciente;
use App\Entity\TipoDeSeguradora;
use App\Repository\PacienteRepository;
use App\Repository\TipoDeSeguradoraRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class AssegurarPacienteType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('paciente', EntityType::class,[
                'class' => Paciente::class,
                'choice_label' => 'nome',
                'label' => 'Província',
                'query_builder' => function(PacienteRepository $pacienteRepository){
                    return $pacienteRepository->createQueryBuilder('p')
                        ->orderBy('p.nome','ASC');
                }
            ])
            ->add('tipoSeguro',EntityType::class,[
                'class' => TipoDeSeguradora::class,
                'choice_label' => 'nomeTipo',
                'label' => 'Tipo de seguro',
                'query_builder' => function(TipoDeSeguradoraRepository $tipoDeSeguradoraRepository){
                    return $tipoDeSeguradoraRepository->createQueryBuilder('t')
                    ->orderBy('t.nomeTipo','ASC');
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => AssegurarPaciente::class,
        ]);
    }
}
