<?php

namespace App\Entity;

use App\Repository\TriagemRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: TriagemRepository::class)]
class Triagem
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $updatedAt = null;

    #[ORM\ManyToOne(inversedBy: 'triagems')]
    private ?Paciente $paciente = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
    private ?string $altura = null;

    #[ORM\Column(type: Types::DECIMAL, precision: 10, scale: 2, nullable: true)]
    private ?string $peso = null;

    #[ORM\Column(length: 50, nullable: true)]
    private ?string $situacao = null;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $codigoTriagem = null;

    #[ORM\Column(nullable: true)]
    private ?bool $isAtivo = null;

    #[ORM\OneToMany(mappedBy: 'codTriagem', targetEntity: MarcacaoConsulta::class)]
    private Collection $marcacaoConsultas;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $situacaoDeentrada = null;

    public function __construct()
    {
        $this->createdAt = new \DateTimeImmutable();
        $this->updatedAt = new \DateTimeImmutable();
        $this->isAtivo = true;
        $this->marcacaoConsultas = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(\DateTimeImmutable $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeImmutable
    {
        return $this->updatedAt;
    }

    public function setUpdatedAt(\DateTimeImmutable $updatedAt): self
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    public function getPaciente(): ?Paciente
    {
        return $this->paciente;
    }

    public function setPaciente(?Paciente $paciente): self
    {
        $this->paciente = $paciente;

        return $this;
    }

    public function getAltura(): ?string
    {
        return $this->altura;
    }

    public function setAltura(?string $altura): self
    {
        $this->altura = $altura;

        return $this;
    }

    public function getPeso(): ?string
    {
        return $this->peso;
    }

    public function setPeso(?string $peso): self
    {
        $this->peso = $peso;

        return $this;
    }

    public function getSituacao(): ?string
    {
        return $this->situacao;
    }

    public function setSituacao(?string $situacao): self
    {
        $this->situacao = $situacao;

        return $this;
    }

    public function getCodigoTriagem(): ?string
    {
        return $this->codigoTriagem;
    }

    public function setCodigoTriagem(?string $codigoTriagem): self
    {
        $this->codigoTriagem = $codigoTriagem;

        return $this;
    }

    public function isIsAtivo(): ?bool
    {
        return $this->isAtivo;
    }

    public function setIsAtivo(?bool $isAtivo): self
    {
        $this->isAtivo = $isAtivo;

        return $this;
    }

    /**
     * @return Collection<int, MarcacaoConsulta>
     */
    public function getMarcacaoConsultas(): Collection
    {
        return $this->marcacaoConsultas;
    }

    public function addMarcacaoConsulta(MarcacaoConsulta $marcacaoConsulta): self
    {
        if (!$this->marcacaoConsultas->contains($marcacaoConsulta)) {
            $this->marcacaoConsultas->add($marcacaoConsulta);
            $marcacaoConsulta->setCodTriagem($this);
        }

        return $this;
    }

    public function removeMarcacaoConsulta(MarcacaoConsulta $marcacaoConsulta): self
    {
        if ($this->marcacaoConsultas->removeElement($marcacaoConsulta)) {
            // set the owning side to null (unless already changed)
            if ($marcacaoConsulta->getCodTriagem() === $this) {
                $marcacaoConsulta->setCodTriagem(null);
            }
        }

        return $this;
    }

    public function getSituacaoDeentrada(): ?string
    {
        return $this->situacaoDeentrada;
    }

    public function setSituacaoDeentrada(?string $situacaoDeentrada): self
    {
        $this->situacaoDeentrada = $situacaoDeentrada;

        return $this;
    }
}
