<?php

namespace App\Entity;

use App\Repository\TipoDeSeguradoraRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: TipoDeSeguradoraRepository::class)]
class TipoDeSeguradora
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 45, nullable: true)]
    private ?string $nomeTipo = null;

    #[ORM\ManyToOne(inversedBy: 'tipoDeSeguradoras')]
    private ?Seguradora $seguradora = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column(nullable: true)]
    private ?bool $isAtivo = null;

    #[ORM\OneToMany(mappedBy: 'tipoSeguro', targetEntity: AssegurarPaciente::class)]
    private Collection $assegurarPacientes;


    public function __construct()
    {
        $this->createdAt = new \DateTimeImmutable();
        $this->isAtivo = true;
        $this->assegurarPacientes = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNomeTipo(): ?string
    {
        return $this->nomeTipo;
    }

    public function setNomeTipo(?string $nomeTipo): self
    {
        $this->nomeTipo = $nomeTipo;

        return $this;
    }

    public function getSeguradora(): ?Seguradora
    {
        return $this->seguradora;
    }

    public function setSeguradora(?Seguradora $seguradora): self
    {
        $this->seguradora = $seguradora;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(?\DateTimeImmutable $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function isIsAtivo(): ?bool
    {
        return $this->isAtivo;
    }

    public function setIsAtivo(?bool $isAtivo): self
    {
        $this->isAtivo = $isAtivo;

        return $this;
    }

    /**
     * @return Collection<int, AssegurarPaciente>
     */
    public function getAssegurarPacientes(): Collection
    {
        return $this->assegurarPacientes;
    }

    public function addAssegurarPaciente(AssegurarPaciente $assegurarPaciente): self
    {
        if (!$this->assegurarPacientes->contains($assegurarPaciente)) {
            $this->assegurarPacientes->add($assegurarPaciente);
            $assegurarPaciente->setTipoSeguro($this);
        }

        return $this;
    }

    public function removeAssegurarPaciente(AssegurarPaciente $assegurarPaciente): self
    {
        if ($this->assegurarPacientes->removeElement($assegurarPaciente)) {
            // set the owning side to null (unless already changed)
            if ($assegurarPaciente->getTipoSeguro() === $this) {
                $assegurarPaciente->setTipoSeguro(null);
            }
        }

        return $this;
    }
}
