<?php

namespace App\Entity;

use App\Repository\SeguradoraRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: SeguradoraRepository::class)]
class Seguradora
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 45, nullable: true)]
    private ?string $nome = null;

    #[ORM\OneToMany(mappedBy: 'seguradora', targetEntity: TipoDeSeguradora::class)]
    private Collection $tipoDeSeguradoras;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $updatedAt = null;

    #[ORM\Column(nullable: true)]
    private ?bool $isAtivo = null;

    public function __construct()
    {
        $this->createdAt = new \DateTimeImmutable();
        $this->updatedAt = new \DateTimeImmutable();
        $this->isAtivo = true;
        $this->tipoDeSeguradoras = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNome(): ?string
    {
        return $this->nome;
    }

    public function setNome(?string $nome): self
    {
        $this->nome = $nome;

        return $this;
    }

    /**
     * @return Collection<int, TipoDeSeguradora>
     */
    public function getTipoDeSeguradoras(): Collection
    {
        return $this->tipoDeSeguradoras;
    }

    public function addTipoDeSeguradora(TipoDeSeguradora $tipoDeSeguradora): self
    {
        if (!$this->tipoDeSeguradoras->contains($tipoDeSeguradora)) {
            $this->tipoDeSeguradoras->add($tipoDeSeguradora);
            $tipoDeSeguradora->setSeguradora($this);
        }

        return $this;
    }

    public function removeTipoDeSeguradora(TipoDeSeguradora $tipoDeSeguradora): self
    {
        if ($this->tipoDeSeguradoras->removeElement($tipoDeSeguradora)) {
            // set the owning side to null (unless already changed)
            if ($tipoDeSeguradora->getSeguradora() === $this) {
                $tipoDeSeguradora->setSeguradora(null);
            }
        }

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(?\DateTimeImmutable $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeImmutable
    {
        return $this->updatedAt;
    }

    public function setUpdatedAt(?\DateTimeImmutable $updatedAt): self
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    public function isIsAtivo(): ?bool
    {
        return $this->isAtivo;
    }

    public function setIsAtivo(?bool $isAtivo): self
    {
        $this->isAtivo = $isAtivo;

        return $this;
    }
}
