<?php

namespace App\Entity;

use App\Repository\PacienteRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: PacienteRepository::class)]
class Paciente
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nome = null;

    #[ORM\Column(length: 20, nullable: true)]
    private ?string $genero = null;

    #[ORM\ManyToOne(inversedBy: 'pacientes')]
    private ?Bairro $bairro = null;

    #[ORM\Column(length: 60, nullable: true)]
    private ?string $tipoSanguineo = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $doencafamiliar = null;

    #[ORM\Column(length: 60, nullable: true)]
    private ?string $grupoSanguineo = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $outrosproblemasDeSaude = null;

    #[ORM\Column(nullable: true)]
    private ?int $contacto = null;

    #[ORM\OneToMany(mappedBy: 'paciente', targetEntity: Triagem::class)]
    private Collection $triagems;

    #[ORM\OneToMany(mappedBy: 'paciente', targetEntity: AssegurarPaciente::class)]
    private Collection $assegurarPacientes;

    public function __construct()
    {
        $this->triagems = new ArrayCollection();
        $this->assegurarPacientes = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNome(): ?string
    {
        return $this->nome;
    }

    public function setNome(?string $nome): self
    {
        $this->nome = $nome;

        return $this;
    }

    public function getGenero(): ?string
    {
        return $this->genero;
    }

    public function setGenero(?string $genero): self
    {
        $this->genero = $genero;

        return $this;
    }

    public function getBairro(): ?Bairro
    {
        return $this->bairro;
    }

    public function setBairro(?Bairro $bairro): self
    {
        $this->bairro = $bairro;

        return $this;
    }

    public function getTipoSanguineo(): ?string
    {
        return $this->tipoSanguineo;
    }

    public function setTipoSanguineo(?string $tipoSanguineo): self
    {
        $this->tipoSanguineo = $tipoSanguineo;

        return $this;
    }

    public function getDoencafamiliar(): ?string
    {
        return $this->doencafamiliar;
    }

    public function setDoencafamiliar(?string $doencafamiliar): self
    {
        $this->doencafamiliar = $doencafamiliar;

        return $this;
    }

    public function getGrupoSanguineo(): ?string
    {
        return $this->grupoSanguineo;
    }

    public function setGrupoSanguineo(?string $grupoSanguineo): self
    {
        $this->grupoSanguineo = $grupoSanguineo;

        return $this;
    }

    public function getOutrosproblemasDeSaude(): ?string
    {
        return $this->outrosproblemasDeSaude;
    }

    public function setOutrosproblemasDeSaude(?string $outrosproblemasDeSaude): self
    {
        $this->outrosproblemasDeSaude = $outrosproblemasDeSaude;

        return $this;
    }

    public function getContacto(): ?int
    {
        return $this->contacto;
    }

    public function setContacto(?int $contacto): self
    {
        $this->contacto = $contacto;

        return $this;
    }

    /**
     * @return Collection<int, Triagem>
     */
    public function getTriagems(): Collection
    {
        return $this->triagems;
    }

    public function addTriagem(Triagem $triagem): self
    {
        if (!$this->triagems->contains($triagem)) {
            $this->triagems->add($triagem);
            $triagem->setPaciente($this);
        }

        return $this;
    }

    public function removeTriagem(Triagem $triagem): self
    {
        if ($this->triagems->removeElement($triagem)) {
            // set the owning side to null (unless already changed)
            if ($triagem->getPaciente() === $this) {
                $triagem->setPaciente(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, AssegurarPaciente>
     */
    public function getAssegurarPacientes(): Collection
    {
        return $this->assegurarPacientes;
    }

    public function addAssegurarPaciente(AssegurarPaciente $assegurarPaciente): self
    {
        if (!$this->assegurarPacientes->contains($assegurarPaciente)) {
            $this->assegurarPacientes->add($assegurarPaciente);
            $assegurarPaciente->setPaciente($this);
        }

        return $this;
    }

    public function removeAssegurarPaciente(AssegurarPaciente $assegurarPaciente): self
    {
        if ($this->assegurarPacientes->removeElement($assegurarPaciente)) {
            // set the owning side to null (unless already changed)
            if ($assegurarPaciente->getPaciente() === $this) {
                $assegurarPaciente->setPaciente(null);
            }
        }

        return $this;
    }

}
