<?php

namespace App\Entity;

use App\Repository\ComunaRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ComunaRepository::class)]
class Comuna
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $nome = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $updatedAt = null;

    #[ORM\ManyToOne(inversedBy: 'comunas')]
    private ?Municipio $municipio = null;

    #[ORM\OneToMany(mappedBy: 'comuna', targetEntity: Bairro::class)]
    private Collection $bairros;

    public function __construct()
    {
        $this->createdAt = new \DateTimeImmutable();
        $this->updatedAt = new \DateTimeImmutable();
        $this->bairros = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNome(): ?string
    {
        return $this->nome;
    }

    public function setNome(?string $nome): self
    {
        $this->nome = $nome;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(?\DateTimeImmutable $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeImmutable
    {
        return $this->updatedAt;
    }

    public function setUpdatedAt(?\DateTimeImmutable $updatedAt): self
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    public function getMunicipio(): ?Municipio
    {
        return $this->municipio;
    }

    public function setMunicipio(?Municipio $municipio): self
    {
        $this->municipio = $municipio;

        return $this;
    }

    /**
     * @return Collection<int, Bairro>
     */
    public function getBairros(): Collection
    {
        return $this->bairros;
    }

    public function addBairro(Bairro $bairro): self
    {
        if (!$this->bairros->contains($bairro)) {
            $this->bairros->add($bairro);
            $bairro->setComuna($this);
        }

        return $this;
    }

    public function removeBairro(Bairro $bairro): self
    {
        if ($this->bairros->removeElement($bairro)) {
            // set the owning side to null (unless already changed)
            if ($bairro->getComuna() === $this) {
                $bairro->setComuna(null);
            }
        }

        return $this;
    }
}
