<?php

namespace App\Controller;

use App\Entity\Municipio;
use App\Form\MunicipioType;
use App\Repository\MunicipioRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/municipio', name: 'app_municipio_')]
class MunicipioController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(MunicipioRepository $municipioRepository): Response
    {
        $municipios = $municipioRepository->findMunicipios();
        return $this->render('municipio/index.html.twig', compact('municipios'));
    }

    #[Route('/add', name: 'add')]
    public function addMunicipio(Request $request, EntityManagerInterface $em): Response
    {
        $municipio = new Municipio();
        $form = $this->createForm(MunicipioType::class,$municipio);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($municipio);
            $em->flush();
            $this->addFlash('success','Municipio salvo com sucesso!');
            return $this->redirectToRoute('app_municipio_add');
        }
        return $this->render('municipio/addMunicipio.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    #[Route('/edit/{id}', name: 'edit')]
    public function editMunicipio(Municipio $municipio,Request $request, EntityManagerInterface $em): Response
    {
        $form = $this->createForm(MunicipioType::class,$municipio);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($municipio);
            $em->flush();
            $this->addFlash('success','Dados do municipio alterado com sucesso!');
            return $this->redirectToRoute('app_municipio_index');
        }
        return $this->render('municipio/editMunicipio.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    #[Route('/apagar/{id}', name: 'delete')]
    public function deleteMunicipio(Municipio $municipio, EntityManagerInterface $em){

        $em->remove($municipio);
        $em->flush();
        $this->addFlash('success','Município removido com sucesso!');
        return $this->redirectToRoute('app_municipio_index');
    }
}
