<?php

namespace App\Controller;

use App\Entity\MarcacaoConsulta;
use App\Form\EditMarcacaoConsultaType;
use App\Form\MarcacaoConsultaType;
use App\Repository\AgendaMedicaRepository;
use App\Repository\MarcacaoConsultaRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use function Symfony\Component\HttpFoundation\getUser;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/marcacao/consulta', name: 'app_admin_marcacao_consulta_')]
class MarcacaoConsultaController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(Request $request,EntityManagerInterface $em,
                          MarcacaoConsultaRepository $consultaRepository, PaginatorInterface $paginator): Response
    {
        $consulta = new MarcacaoConsulta();
        $form = $this->createForm(MarcacaoConsultaType::class,$consulta);
        $form->handleRequest($request);
        if($form->isSubmitted() && $form->isValid()){
            $em->persist($consulta);
            $em->flush();
            $this->addFlash('success','Marcação de consulta salva com sucesso!');
            return $this->redirectToRoute('app_admin_marcacao_consulta_index');
        }
        $query = $consultaRepository->findMarcacaoConsultas();
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),4 );
        return $this->render('marcacao_consulta/index.html.twig', [
            'form' => $form->createView(),
            'pagination' => $pagination,
        ]);
    }

    #[Route('/editar/{id}', name: 'edit')]
    public function editMarcacaoConsulta(MarcacaoConsulta $marcacaoConsulta, Request $request, EntityManagerInterface $em): Response
    {
        $form = $this->createForm(EditMarcacaoConsultaType::class,$marcacaoConsulta);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($marcacaoConsulta);
            $em->flush();
            $this->addFlash('success','Marcação de consulta alterado com sucesso!');
            return $this->redirectToRoute('app_admin_marcacao_consulta_index');
        }
        return $this->render('marcacao_consulta/editMarcacaoConsulta.html.twig', [
            'form' => $form->createView(),
        ]);
    }


    #[Route('/do/medico', name: 'do_medico')]
    public function consultasMarcadas(Request $request,
                          MarcacaoConsultaRepository $consultaRepository, PaginatorInterface $paginator): Response
    {
        $user = $this->getUser();
        $query = $consultaRepository->findMarcacaoConsultasByMedico($user);
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),4 );
        return $this->render('marcacao_consulta/consultasMarcada.html.twig', [
            'pagination' => $pagination,
        ]);
    }

}
