<?php

namespace App\Controller;

use App\Entity\Comuna;
use App\Form\ComunaType;
use App\Repository\ComunaRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/comuna', name: 'app_comuna_')]
class ComunaController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(ComunaRepository $comunaRepository): Response
    {
        $comunas = $comunaRepository->findComunas();
        return $this->render('comuna/index.html.twig', compact('comunas'));
    }

    #[Route('/add', name: 'add')]
    public function addComuna(Request $request, EntityManagerInterface $em): Response
    {
        $comuna = new Comuna();
        $form = $this->createForm(ComunaType::class,$comuna);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($comuna);
            $em->flush();
            $this->addFlash('success','Comuna salvo com sucesso!');
            return $this->redirectToRoute('app_comuna_add');
        }
        return $this->render('comuna/addComuna.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
