<?php

namespace App\Controller;

use App\Repository\CalendarioMedicoRepository;
use App\Repository\CalendarioMedRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class CalendarioPrincipalController extends AbstractController
{
    #[Route('/calendario/principal', name: 'app_calendario_principal')]
    public function index(CalendarioMedRepository $calendarioMedRepository): Response
    {
        $events = $calendarioMedRepository->findAll();

        $dados =[];

        foreach ($events as $event){
            $dados[] = [
                'id' => $event->getId(),
                'start' => $event->getStart()->format('Y-m-d H:i:s'),
                'end' => $event->getEnd()->format('Y-m-d H:i:s'),
                'title' => $event->getTitle(),
                'description' => $event->getDescription(),
                'backgroundColor' => $event->getBackgroundColor(),
                'borderColor' => $event->getBorderColor(),
                'textColor' => $event->getTextColor(),
                'allDay' => $event->isAllDay()
            ];
        }

        $dado = json_encode($dados);
        return $this->render('calendario_principal/index.html.twig', [
            'dado' => $dado,
        ]);
    }
}
