<?php

namespace App\Controller;

use App\Entity\Banco;
use App\Form\BancoType;
use App\Repository\BancoRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/banco', name: 'app_banco_')]
class BancoController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(BancoRepository $bancoRepository): Response
    {
        $bancos = $bancoRepository->findBancos();
        return $this->render('banco/index.html.twig', compact('bancos'));
    }

    #[Route('/add', name: 'add')]
    public function addComuna(Request $request, EntityManagerInterface $em): Response
    {
        $banco = new Banco();
        $form = $this->createForm(BancoType::class,$banco);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($banco);
            $em->flush();
            $this->addFlash('success','Coordenadas bancarias salva com sucesso!');
            return $this->redirectToRoute('app_banco_add');
        }
        return $this->render('banco/addBanco.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
