<?php

namespace App\Controller;

use App\Entity\CalendarioMed;
use App\Entity\CalendarioMedico;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class ApiController extends AbstractController
{
    #[Route('/api', name: 'app_api')]
    public function index(): Response
    {

        return $this->render('api/index.html.twig', [
            'controller_name' => 'ApiController',
        ]);
    }

    #[Route('/api/{id}/edit', name: 'app_api_event_edit', methods: ['PUT'])]
    public function majEvent(?CalendarioMed $calendario, Request $request, EntityManagerInterface $em): Response
    {
        $dados = json_decode($request->getContent());
        if(
            isset($dados->title) && !empty($dados->title) &&
            isset($dados->start) && !empty($dados->start) &&
            isset($dados->description) && !empty($dados->description) &&
            isset($dados->backgroundColor) && !empty($dados->backgroundColor) &&
            isset($dados->borderColor) && !empty($dados->borderColor) &&
            isset($dados->textColor) && !empty($dados->textColor)&&
            isset($dados->allDay) && !empty($dados->allDay)
        ){

            $code = 200;

            if(!$calendario){
                $calendario = new CalendarioMed();
                $code = 201;
            }

            $calendario->setTitle($dados->title);
            $calendario->setStart(new \DateTime($dados->start));
            $calendario->setDescription($dados->description);

            if($dados->allDay){
                $calendario->setEnd(new \DateTime($dados->start));
            }else{
                $calendario->setEnd(new \DateTime($dados->end));
            }

            $calendario->setBackgroundColor($dados->backgroundColor);
            $calendario->setBorderColor($dados->borderColor);
            $calendario->setTextColor($dados->textColor);
            $calendario->setAllDay($dados->allDay);

            $em->persist($calendario);
            $em->flush();

            return new Response('Ok',$code);
        }else{
            return new Response('Dados impletos',404);
        }

    }
}
