<?php

namespace App\Controller;

use App\Entity\Usuario;
use App\Repository\MarcacaoConsultaRepository;
use App\Repository\PacienteRepository;
use App\Repository\TriagemRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use function Symfony\Component\String\match;


#[Route('/principal', name: 'app_principal_')]
class AdminController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(PacienteRepository $pacienteRepository, TriagemRepository $triagemRepository, MarcacaoConsultaRepository $consultaRepository): Response
    {
        $pacientes = $pacienteRepository->findAll();
        $triagens = $triagemRepository->findAll();
        $consultas = $consultaRepository->findAll();
        $this->denyAccessUnlessGranted("IS_AUTHENTICATED_FULLY");

        /** @var Usuario $user */
        $user = $this->getUser();

        return match ($user->isVerified()){
            true => $this->render('admin/index.html.twig',compact('pacientes','triagens','consultas')),
            false => $this->render('admin/please-verify-email.html.twig'),
        };
    }
}
